<?php
require_once './views/index.php';

$sql = "SELECT destinatario, valor, chave_pix, conta_corrente_id, 
                data_pagamento, status_pagamento, data_criacao, data_atualizacao 
        FROM pagamentos";
$result = $conexao->query($sql);
?>

<table>
    <tr>
        <th>*</th>
        <th>Destinatário</th>
        <th>Valor</th>
        <th>Chave PIX</th>
        <th>Conta Corrente</th>
        <th>Data pagamento</th>
        <th>Status</th>
        <th>Criação</th>
        <th>Atualização</th>
    </tr>
    <?php while ($row = $result->fetch_assoc()): ?>
    <tr>
        <td class="actionsTable">
            <?php 
            button_icon("./images/edit.svg", "Edição", "edit", "openFormModal()");
            button_icon("./images/trash.svg", "Remoção", "remove", "openModal()");
            ?>
        </td>
        <td><?= htmlspecialchars($row['destinatario'] ?? 'N/A') ?></td>
        <td>R$ <?= number_format($row['valor'] ?? 0, 2, ',', '.') ?></td>
        <td><?= htmlspecialchars($row['chave_pix'] ?? 'N/A') ?></td>
        <td><?= htmlspecialchars($row['conta_corrente_id'] ?? 'N/A') ?></td>
        <td><?= date('d/m/Y H:i', strtotime($row['data_pagamento'])) ?></td>
        <td><?php tag($row['status_pagamento'] ?? 'N/A') ?></td>
        <td><?= date('d/m/Y H:i', strtotime($row['data_criacao'])) ?></td>
        <td><?= date('d/m/Y H:i', strtotime($row['data_atualizacao'])) ?></td>
    </tr>
    <?php endwhile; ?>
</table>

