<?php
header('Content-Type: application/json'); // Deve ser a PRIMEIRA linha

// Substitua require_once 'index.php' por conexão direta
$conexao = new mysqli("localhost", "root", "", "autopag");
if ($conexao->connect_error) {
    echo json_encode(["success" => false, "message" => "Erro de conexão: " . $conexao->connect_error]);
    exit;
}

try {
    // Recebe os dados
    $data = json_decode(file_get_contents('php://input'), true);
    $conta = $data['account'] ?? '';

    // Validação básica
    if (empty($conta)) {
        throw new Exception("Conta não selecionada!");
    }

    // Passo 1: Atualiza status para "Processando"
    $sqlUpdate = "UPDATE pagamentos 
                  SET status_pagamento = 'Processando', 
                      data_atualizacao = NOW() 
                  WHERE conta_corrente_id = ?";
    $stmt = $conexao->prepare($sqlUpdate);
    $stmt->bind_param("s", $conta);
    $stmt->execute();

    // Passo 2: Chamar API Python
    $apiUrl = "http://localhost:5000/api/request/RotinaPix.py";
    $payload = ['conta' => $conta, 'timestamp' => time()];

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Passo 3: Tratar resposta da API
    if ($httpCode !== 200) {
        throw new Exception("Falha na API: Código $httpCode");
    }

    $respostaApi = json_decode($response, true);
    if (!$respostaApi['success']) {
        throw new Exception($respostaApi['message'] ?? "Erro desconhecido");
    }

    // Passo 4: Atualizar status para "Finalizado"
    $sqlUpdateFinal = "UPDATE pagamentos 
                       SET status_pagamento = 'Finalizado', 
                           data_atualizacao = NOW() 
                       WHERE conta_corrente_id = ?";
    $stmtFinal = $conexao->prepare($sqlUpdateFinal);
    $stmtFinal->bind_param("s", $conta);
    $stmtFinal->execute();

    echo json_encode(['success' => true, 'message' => 'Pagamentos processados!']);

} catch (Exception $e) {
    // Atualiza status para "Falha" em caso de erro
    if (isset($conta)) {
        $sqlUpdateError = "UPDATE pagamentos 
                           SET status_pagamento = 'Falha', 
                               data_atualizacao = NOW() 
                           WHERE conta_corrente_id = ?";
        $stmtError = $conexao->prepare($sqlUpdateError);
        $stmtError->bind_param("s", $conta);
        $stmtError->execute();
    }

    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conexao->close();
?>