<?php

require "Connection.php";
require "Pagamento.php";

class PagamentoModel{
    public $table = "pagamentos";

    public function select(){
        $stmt = Connection::getConn()->prepare("SELECT * FROM $this->table");
        $stmt->setFetchMode(PDO::FETCH_CLASS, 'Pagamento');
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function create(Pagamento $pagamento){

    }

    public function update(Pagamento $pagamento){
        try{
            $sql = "UPDATE $this->table SET valor = ?, status_pagamento = ? WHERE id = ?";
            $stmt = Connection::getConn()->prepare($sql);
            $stmt->bindValue(1, $pagamento->getValor());
            $stmt->bindValue(2, $pagamento->getStatus_pagamento());
            $stmt->bindValue(3, $pagamento->getId());
            return $stmt->execute();
        }
        catch(PDOException $error){
            $_SESSION['error'] = $error->getMessage();
        }
    }

    public function delete($id){
        try{
            $sql = "DELETE FROM $this->table WHERE id = ?";
            $stmt = Connection::getConn()->prepare($sql);
            $stmt->bindValue(1, $id);
            return $stmt->execute();
        }
        catch(PDOException $error){
            $_SESSION['error'] = $error->getMessage();
        }
    }

    public function findId($id){
        $stmt = Connection::getConn()->prepare("SELECT * FROM $this->table WHERE id = ?");
        $stmt->bindValue(1, $id);
        $stmt->setFetchMode(PDO::FETCH_CLASS, 'Pagamento');
        $stmt->execute();
        return $stmt->fetch();
    }

    public function deleteAll(){
        try{
            $sql = "DELETE FROM $this->table";
            $stmt = Connection::getConn()->prepare($sql);
            return $stmt->execute();
        }
        catch(PDOException $error){
            $_SESSION['error'] = $error->getMessage();
        }
    }
}