<?php

/**
 * Summary of tag
 * @param mixed $status text inside the tag
 * @return void
 */
function tag($status){
    $properties = array(
        "Pendente" => array(
            "color" => "#ff9800",
            "backgroundColor" => "#fde0b5"
        ),
        "Finalizado" => array(
            "color" => "#799cff",
            "backgroundColor" => "#ecf2ff"
        ),
        "Rejeitado" => array(
            "color" => "#f44336",
            "backgroundColor" => "#fcd2d2"
        ),
        "Aprovado" => array(
            "color" => "#247353",
            "backgroundColor" => "#c9d9dd"
        )
    );

    if (!array_key_exists($status, $properties)) {
        echo "<td>N/A</td>";
    }
    else{
        $styles = "color:" . $properties[$status]["color"] . " ; background-color:" . $properties[$status]["backgroundColor"] . ";";
        echo "
            <td>
                <span class='tag' style='$styles' >
                    $status
                </span>
            </td>
        ";
    }
    
}