<?php
include "./components/button_icon.php";
include "./components/button_img.php";
include "./components/button_text.php";
include "./components/button_icon_text.php";
include "./components/tag.php";
include "./components/modal.php";
include "./components/formModal.php";
include "./components/flash_message.php";
include "./components/dropdown.php";


// Conectar ao banco de dados
$conexao = new mysqli("localhost", "root", "", "autopag");
if ($conexao->connect_error) {
    die("Conexão falhou: " . $conexao->connect_error);
}

// Consultar os dados da tabela
$sql = "SELECT id, destinatario, valor, chave_pix, conta_corrente_id, data_pagamento, status_pagamento, data_criacao, data_atualizacao FROM pagamentos";
$result = $conexao->query($sql);

// Verificar se a consulta foi bem-sucedida
if (!$result) {
    die("Erro na consulta: " . $conexao->error);
}

// variavel para calcular valor final
$valorFinal = 0;

session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include "./includes/head.php"; ?>
    <title>Home</title>
</head>

<body>
    <?php modal("./images/trash.svg", "Tem certeza?", "A exclusão apagará o registro permanentemente.", array("text" => 'Excluir')); ?>
    <?php formModal(); ?>
    <?php include "./includes/nav.php" ?>
    <div class="modal-overlay" id="modalOverlay"></div>
    <main>
        <?php include "./includes/header.php"; ?>
        <div class="pageContent">
            <div class="banner">
                <div class="texts">
                    <h3>Página Principal</h3>
                    <div class="src">
                        <p>Home</p>
                        <span class="separator"></span>
                        <p>Tabela</p>
                    </div>
                </div>
                <img src="./images/table.svg" alt="Logo icon">
            </div>
            <div class="controlls">
                <div class="select_container">
                    <p>Contas Correntes:</p>
                    <select name="account" id="account">
                        <option value="">Selecione a conta</option>
                        <option value="0000000000100">i9 Process</option>
                        <option value="0000000000101">i9 Solutions</option>
                    </select>
                    <button class="submitButton" id="Enviar pagamentos">Enviar pagamentos</button>
                </div>
                <div class="import-section">
                    <h3>Importar Dados do Excel:</h3>
                    <form action="../importar_python.php" method="POST" enctype="multipart/form-data">
                        <label for="file" class="custom-file-button">Escolha um arquivo</label>
                        <p id="file-name">Escolha um arquivo</p>
                        <input type="file" id="file" name="excelparceiros" accept=".xlsx, .xls" required>
                        <button type="submit" class="submitButton">Importar</button>
                    </form>
                </div>
            </div>

            <script>
                // Novo código integrado
                document.getElementById('Enviar pagamentos').addEventListener('click', function () {
                    const account = document.getElementById('account').value;
                    const button = this;

                    // Validar seleção
                    if (!account) {
                        alert('Selecione uma conta!');
                        return;
                    }

                    // Feedback visual
                    button.innerHTML = "Processando...";
                    button.disabled = true;

                    fetch('http://localhost:5000/Carregar_dados', {
                        method: 'GET',
                        headers: { 'Content-Type': 'application/json' },

                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert(data.message);
                                atualizarTabela();
                            } else {
                                throw new Error(data.message);
                            }
                        })
                        .catch(error => {
                            alert(error.message);
                        })
                        .finally(() => {
                            button.innerHTML = "Enviar pagamentos";
                            button.disabled = false;
                        });
                });

                // Função para atualizar tabela
                function atualizarTabela() {
                    fetch('/Carregar_dados.php')
                        .then(response => response.text())
                        .then(html => {
                            document.querySelector('.table_container').innerHTML = html;
                        });
                }
            </script>

            <?php 
                if(isset($_SESSION['success'])){
                    flash_message('success', $_SESSION['success']);
                }

                if(isset($_SESSION['error'])){
                    flash_message('error', $_SESSION['success']);
                }
            ?>

            <div class="container">
                <h3 class="title">Tabela</h3>
                <div class="tableControlls">
                    <p>Controle de tabela:</p>
                    <div class="tableControll">
                        <input type="checkbox" id="all"/>
                        <label for="all">Selecionar todos</label>
                    </div>
                    <div class="tableControll">
                        <?php button_icon("./images/trash.svg", "Remoção", "remove", "openModal(null)"); ?>
                        <label>Excluir todos</label>
                    </div>
                </div>
                <div class="table-wrapper">
                    <div class="table_container">
                        <table>
                            <tr>
                                <th></th>
                                <th>*</th>
                                <th>Destinatário</th>
                                <th>Valor</th>
                                <th>Chave PIX</th>
                                <th>Conta Corrente</th>
                                <th>Data pagamento</th>
                                <th>Status</th>
                                <th>Criação</th>
                                <th>Atualização</th>
                            </tr>
                            <!-- Ínicio para inserção de dados aqui -->
                            <?php
                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo '<tr>';
                                    echo '<td><input type="checkbox" class="checkboxs"/></td>';
                                    echo '<td class="actionsTable">';
                                    button_icon("./images/edit.svg", "Edição", "edit", "openFormModal(" . $row["id"] . ")");
                                    button_icon("./images/trash.svg", "Remoção", "remove", "openModal(" . $row["id"] . ")");
                                    echo '</td>';
                                    echo '<td>' . htmlspecialchars($row["destinatario"] ?? 'N/A') . '</td>';
                                    echo '<td>R$' . number_format($row["valor"] ?? 0, 2, ',', '.') . '</td>';
                                    echo '<td>' . htmlspecialchars($row["chave_pix"] ?? 'N/A') . '</td>';
                                    echo '<td>' . htmlspecialchars($row["conta_corrente_id"] ?? 'N/A') . '</td>';
                                    echo '<td>' . date('d/m/Y H:i', strtotime($row["data_pagamento"] ?? '')) . '</td>';
                                    tag($row["status_pagamento"]);
                                    echo '<td>' . date('d/m/Y H:i', strtotime($row["data_criacao"] ?? '')) . '</td>';
                                    echo '<td>' . date('d/m/Y H:i', strtotime($row["data_atualizacao"] ?? '')) . '</td>';
                                    echo '</tr>';
                                    $valorFinal += $row["valor"];
                                }
                            } else {
                                echo '<tr><td colspan="8">Nenhum dado encontrado</td></tr>';
                            }
                            ?>
                            <!-- Fim para inserção de dados aqui -->
                        </table>
                    </div>
                </div>
                <div class="tabelInfos">
                    <p>Informações da tabela</p>
                    <div class="info">
                        <p>Valor total:</p>
                        <span>R$<?= number_format($valorFinal, 2, ",", ".") ?></span>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php include "./includes/scripts.php"; ?>
</body>

</html>

<?php
    session_unset();
?>