document.getElementById('navButton').addEventListener('click', (event) => {
    event.preventDefault();

    document.getElementById("nav").classList.toggle("closed")
    document.getElementById("user_nav").classList.toggle("closed")

    let logo = document.getElementsByClassName('logo')[0]
    logo.classList.toggle("closed")

    const isMobile = window.innerWidth <= 768

    document.querySelectorAll(".text_button_icon_text, .text_span, #info, #power").forEach(element => {
        element.style.display = logo.classList.contains('closed') ? 'none' : 'block';
    })


    document.querySelectorAll(".button_icon_text").forEach(element => {
        element.style.display = 'flex'
        element.style.alignItems = 'center'
        element.style.justifyContent = 'center'
    })

    document.querySelectorAll(".button_icon_text img").forEach(element => {
        element.style.marginLeft = 0
    })

    if(!logo.classList.contains('closed')){
        document.querySelectorAll(".button_icon_text").forEach(element => {
            element.style.alignItems = 'center'
            element.style.justifyContent = 'space-between'
        })
    }


    if (isMobile) {
        if (nav.classList.contains("closed")) {
            nav.style.display = 'none'
        } else {
            nav.style.display = 'block'
            nav.style.position = 'absolute'
        }
    }
    else{
        document.getElementsByTagName("main")[0].classList.toggle("closed")
    }
})

document.addEventListener('click', (event) => {
    const nav = document.getElementById("nav");
    const userNav = document.getElementById("user_nav");
    const logo = document.getElementsByClassName('logo')[0];

    if (window.innerWidth <= 768){
        if (!nav.contains(event.target) && !document.getElementById('navButton').contains(event.target)) {
            nav.classList.add("closed");
            userNav.classList.add("closed");
            logo.classList.add("closed");

            document.querySelectorAll(".text_button_icon_text, .text_span, #info, #power").forEach(element => {
                element.style.display = 'none';
            });

            logo.setAttribute("src", "./images/logoipsum-363.svg");

            nav.style.display = 'none';
        }
    }
});