import requests
import os

def consultar_pagamento_pix(token, codigoSolicitacao=None):
  if not codigoSolicitacao:
    raise ValueError("Código de solicitação não pode ser vazio ou None.")
  
  # Verifica se há na mesma pasta desse script os arquivos .crt e .key
  script_dir = os.path.dirname(os.path.abspath(__file__))
  crt_files = [f for f in os.listdir(script_dir) if f.endswith('.crt')]
  key_files = [f for f in os.listdir(script_dir) if f.endswith('.key')]

  if len(crt_files) != 1 or len(key_files) != 1:
    raise FileNotFoundError("Certificado .crt ou chave .key não encontrados ou múltiplos arquivos encontrados na pasta.")

  cert_file = os.path.join(script_dir, crt_files[0])
  key_file = os.path.join(script_dir, key_files[0])

  cabecalhos = {"Authorization": "Bearer " + token}

  response = requests.get("https://cdpj.partners.bancointer.com.br/banking/v2/pix/" + codigoSolicitacao,
               headers=cabecalhos,
               cert=(cert_file, key_file),
               data=None)

  response.raise_for_status()

  return response.json()