import requests
import json
import os
from decimal import Decimal
from datetime import datetime


def solicitar_pagamento_pix(token, valor, chave_destinatario, data_pagamento=None, conta_corrente=None):
  # Verifica se há na mesma pasta desse script os arquivos .crt e .key
  script_dir = os.path.dirname(os.path.abspath(__file__))
  crt_files = [f for f in os.listdir(script_dir) if f.endswith('.crt')]
  key_files = [f for f in os.listdir(script_dir) if f.endswith('.key')]

  if len(crt_files) != 1 or len(key_files) != 1:
    raise FileNotFoundError("Certificado .crt ou chave .key não encontrados ou múltiplos arquivos encontrados na pasta.")

  cert_file = os.path.join(script_dir, crt_files[0])
  key_file = os.path.join(script_dir, key_files[0])
  # Converter valor de Decimal para float
  if isinstance(valor, Decimal):
    valor = float(valor)

  emitir_body = json.dumps({
    "valor": valor,
    "destinatario": {
      "tipo": "CHAVE",
      "chave": chave_destinatario
    }
  })

  cabecalhos = {"Authorization": "Bearer " + token, "Content-Type": "Application/json"}
  if conta_corrente:
    cabecalhos["x-conta-corrente"] = conta_corrente
  if data_pagamento:
    if isinstance(data_pagamento, datetime):
      data_pagamento = data_pagamento.strftime('%Y-%m-%d')
    cabecalhos["dataPagamento"] = data_pagamento

  print("Headers:", cabecalhos)
  print("Body:", emitir_body)

  response = requests.post("https://cdpj.partners.bancointer.com.br/banking/v2/pix",
               headers=cabecalhos,
               cert=(cert_file, key_file),
               data=emitir_body)

  print("Response Status Code:", response.status_code)
  print("Response Text:", response.text)

  response.raise_for_status()

  return response.json()


