import requests
import os

def obter_token(client_id, client_secret):
  request_body = f"client_id={client_id}&client_secret={client_secret}&scope=pagamento-pix.write pagamento-pix.read&grant_type=client_credentials"
  
  # Verifica se há na mesma pasta desse script os arquivos .crt e .key
  script_dir = os.path.dirname(os.path.abspath(__file__))
  crt_files = [f for f in os.listdir(script_dir) if f.endswith('.crt')]
  key_files = [f for f in os.listdir(script_dir) if f.endswith('.key')]

  if len(crt_files) != 1 or len(key_files) != 1:
    raise FileNotFoundError("Certificado .crt ou chave .key não encontrados ou múltiplos arquivos encontrados na pasta.")

  cert_file = os.path.join(script_dir, crt_files[0])
  key_file = os.path.join(script_dir, key_files[0])

  response = requests.post("https://cdpj.partners.bancointer.com.br/oauth/v2/token",
               headers={"Content-Type": "application/x-www-form-urlencoded"},
               cert=(cert_file, key_file),
               data=request_body)
  
  response.raise_for_status()
  
  token = response.json().get("access_token")
  if not token:
    raise RuntimeError("Não foi possível obter o access_token.")
  
  return token

#"https://cdpj-sandbox.partners.uatinter.co/oauth/v2/token" - TOKEN SANDBOX