from CriarPix import solicitar_pagamento_pix
from ConsultPix import consultar_pagamento_pix
from ObterToken import obter_token
from flask import Flask, jsonify, request
from flask_cors import CORS

app = Flask(__name__)
CORS(app)

@app.route('/Carregar_dados', methods=['GET'])
def enviar_pagamentos():
    try:
        # print("Requisição recebida")  # Log para depuração
        processar_pagamentos()
        return jsonify({"status": "success", "message": "Pagamentos processados com sucesso!"}), 200
    except Exception as e:
        print(f"Erro: {str(e)}")  # Log do erro
        return jsonify({"status": "error", "message": str(e)}), 500

import mysql.connector
from datetime import datetime

def processar_pagamentos():
    client_id="f9091f15-da77-4a75-ac8a-ec4de53b6dcd" #Alterar para integração oficial
    client_secret="c69414c7-0d60-4dc1-931f-d9050a4b7fbe"
    # Conectar ao banco de dados
    conn = mysql.connector.connect(
        host="127.0.0.1",
        user="root",
        password="",
        database="autopag"
    )
    cursor = conn.cursor(dictionary=True)

    # Selecionar pagamentos aprovados
    cursor.execute("SELECT * FROM Pagamentos WHERE status_pagamento = 'Aprovado'")
    pagamentos = cursor.fetchall()

    token = obter_token(client_id, client_secret)
    # print("Token obtido com sucesso:", token)

    for pagamento in pagamentos:
        pagamento_id = pagamento['id']

        # Solicitar pagamento pix
        # Obter o número da conta corrente
        cursor.execute("SELECT numero_conta FROM ContaCorrente WHERE id = %s", (pagamento['conta_corrente_id'],))
        conta_corrente_result = cursor.fetchone()
        conta_corrente = conta_corrente_result['numero_conta'] if conta_corrente_result else None
        
        try:
            # Solicitar pagamento pix
            if conta_corrente:
                resposta_solicitacao = solicitar_pagamento_pix(
                token,
                pagamento['valor'], 
                pagamento['chave_pix'], 
                pagamento['data_pagamento'],
                conta_corrente
                )
            else:
                resposta_solicitacao = solicitar_pagamento_pix(
                token,
                pagamento['valor'], 
                pagamento['chave_pix'], 
                pagamento['data_pagamento']
                )

            # Extrair o código de solicitação da resposta
            codigo_solicitacao = resposta_solicitacao['codigoSolicitacao']

            # Consultar pagamento pix
            retorno_pagamento = consultar_pagamento_pix(token, codigo_solicitacao)
        except Exception as ex:
            print(ex)
            cursor.execute("UPDATE Pagamentos SET status_pagamento = 'Error Ex' WHERE id = %s", (pagamento_id,))
            conn.commit()
            continue
        
        # Criar registro na tabela RetornoPagamentos
        transacao_pix = retorno_pagamento['transacaoPix']

        if not transacao_pix:
            # raise KeyError("Campo 'transacaoPix' não está presente na resposta.")
            cursor.execute("UPDATE Pagamentos SET status_pagamento = 'Error' WHERE id = %s", (pagamento_id,))
            conn.commit()
        else:
            # Mudar status para finalizado
            cursor.execute("UPDATE Pagamentos SET status_pagamento = 'Finalizado' WHERE id = %s", (pagamento_id,))
            conn.commit()
            
        
        # Convert datetime values to the correct format
        #dataHoraMovimento = datetime.strptime(transacao_pix['dataHoraMovimento'], '%Y-%m-%dT%H:%M:%S.%fZ').strftime('%Y-%m-%d %H:%M:%S')
        # dataHoraSolicitacao = datetime.strptime(transacao_pix.get('dataHoraSolicitacao',datetime.now().strftime('%Y-%m-%dT%H:%M:%S.%fZ')),'%Y-%m-%dT%H:%M:%S.%fZ').strftime('%Y-%m-%d %H:%M:%S')
        
        # cursor.execute("""
        #     INSERT INTO RetornoPagamentos(
        #         id_pagamento, codigo_solicitacao, tipo_retorno, conta_corrente, recebedor, erros, endtoend, valor_retorno, status_retorno, dataHoraMovimento, chave
        #     ) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
        # """,(
        #     pagamento_id, 
        #     transacao_pix['codigoSolicitacao'], 
        #     'API respondeu', 
        #     transacao_pix['contaCorrente'], 
        #     str(transacao_pix.get('recebedor', "")), 
        #     str(transacao_pix['erros']), 
        #     transacao_pix['endToEnd'], 
        #     transacao_pix['valor'], 
        #     transacao_pix['status'], 
        #     #dataHoraMovimento, 
        #     dataHoraSolicitacao, 
        #     transacao_pix['chave']
        # ))
        # conn.commit()

        # Obter o id do registro de retorno de pagamento criado
        # retorno_pagamento_id = cursor.lastrowid

        # # Criar registro na tabela HistoricoOperacoes
        # for historico in retorno_pagamento['historico']:
        #     dataHoraEvento = datetime.strptime(historico['dataHoraEvento'], '%Y-%m-%dT%H:%M:%S.%fZ').strftime('%Y-%m-%d %H:%M:%S')
        #     cursor.execute("""
        #         INSERT INTO HistoricoOperacoes (
        #             id_pagamento, id_retorno_pagamento, Status, dataHoraEvento
        #         ) VALUES (%s, %s, %s, %s)
        #     """, (
        #         pagamento_id, 
        #         retorno_pagamento_id, 
        #         historico['status'], 
        #         dataHoraEvento
        #     ))
        #     conn.commit()

    # Fechar conexão com o banco de dados
    cursor.close()
    conn.close()

    return

if __name__ == "__main__":
   #processar_pagamentos()
   app.run(debug=True, port=5000, host="0.0.0.0")