import pandas as pd
import mysql.connector
from mysql.connector import Error

# Configurações do banco de dados
host = 'localhost'
user = 'root'
password = ''  # Sem senha
database = 'autopag'

# Caminho para o arquivo Excel
excel_file_path = r'c:\xampp\htdocs\api\scriptexcel\excelparceiros.xlsx'

# Leia o arquivo Excel
df = pd.read_excel(excel_file_path)

# Verifique se as colunas de data estão no formato datetime
df['data_pagamento'] = pd.to_datetime(df['data_pagamento'], errors='coerce')
df['data_criacao'] = pd.to_datetime(df['data_criacao'], errors='coerce')
df['data_atualizacao'] = pd.to_datetime(df['data_atualizacao'], errors='coerce')

# Converte as colunas de data para strings no formato MySQL
df['data_pagamento'] = df['data_pagamento'].dt.strftime('%Y-%m-%d')
df['data_criacao'] = df['data_criacao'].dt.strftime('%Y-%m-%d')
df['data_atualizacao'] = df['data_atualizacao'].dt.strftime('%Y-%m-%d')

try:
    # Conecte-se ao banco de dados
    connection = mysql.connector.connect(
        host=host,
        user=user,
        password=password,
        database=database
    )

    if connection.is_connected():
        cursor = connection.cursor()

        # Itere sobre as linhas do DataFrame e insira os dados no banco de dados
        for index, row in df.iterrows():
            sql = """INSERT INTO pagamentos (destinatario, valor, chave_pix, conta_corrente_id, data_pagamento, status_pagamento, data_criacao, data_atualizacao)
                     VALUES (%s, %s, %s, %s, %s, %s, %s, %s)"""
            values = (row['destinatario'], row['valor'], row['chave_pix'], row['conta_corrente_id'],
                      row['data_pagamento'], row['status_pagamento'], row['data_criacao'], row['data_atualizacao'])
            
            cursor.execute(sql, values)

        # Commit das alterações
        connection.commit()
        print("Dados inseridos com sucesso!")

except Error as e:
    print(f"Erro ao conectar ao MySQL: {e}")

finally:
    if connection.is_connected():
        cursor.close()
        connection.close()